from pages.base_page import BasePage
from selenium.webdriver.common.by import By
from selenium.webdriver.support.select import Select
import os

import tasks.task1 as task1
import tasks.task2 as task2
import tasks.task3 as task3


class FinalVolgaITPage(BasePage):
    PAGE_URL = "https://way2automation.com/way2auto_jquery/registration.php#load_box"

    FIRSTNAME_INPUT = ("xpath", "//input[@name='name']")
    LASTNAME_INPUT = ("xpath", "(//input[@type='text'])[2]")
    FIRSTNAME_LABEL = ("xpath", "//label[text()='First Name:']")
    LASTNAME_LABEL = ("xpath", "//label[text()='Last Name:']")

    SINGLE_RADIO = ("xpath", "//label[contains(text(), 'Single')]/input")
    MARRIED_RADIO = ("xpath", "//label[contains(text(), 'Married')]/input")
    DIVORCED_RADIO = ("xpath", "//label[contains(text(), 'Divorced')]/input")

    DANCE_CHECKBOX = ("xpath", "//label[contains(text(), 'Dance')]/input")
    READING_CHECKBOX = ("xpath", "//label[contains(text(), 'Reading')]/input")
    CRICKET_CHECKBOX = ("xpath", "//label[contains(text(), 'Cricket')]/input")

    COUNTRY_SELECT = ("xpath", "//fieldset/select[@name='']")
    COUNTRY_OPTION = lambda self, index: ("xpath", f"//fieldset/select[@name='']/option[{index}]")

    MONTH_SELECT = ("xpath", "(//fieldset/div/select)[1]")
    DAY_SELECT = ("xpath", "(//fieldset/div/select)[2]")
    YEAR_SELECT = ("xpath", "(//fieldset/div/select)[3]")

    MONTH_OPTION = lambda self, text: ("xpath", f"(//fieldset/div/select)[1]/option[text()={text}]")
    DAY_OPTION = lambda self, text: ("xpath", f"(//fieldset/div/select)[2]/option[text()={text}]")
    YEAR_OPTION = lambda self, text: ("xpath", f"(//fieldset/div/select)[3]/option[text()={text}]")

    PHONE_INPUT = ("xpath", "//fieldset[@class='fieldset']/input[@name='phone']")
    USERNAME_INPUT = ("xpath", "//fieldset[@class='fieldset']/input[@name='username']")
    EMAIL_INPUT = ("xpath", "//fieldset[@class='fieldset']/input[@name='email']")

    FILE_INPUT = ("xpath", "//input[@type='file']")

    ABOUT_YOURSELF = ("xpath", "//fieldset/textarea")

    PASSWORD_INPUT = ("xpath", "//fieldset[@class='fieldset']/input[@type='password'][@name='password']")
    CONFIRM_PASSWORD_INPUT = ("xpath", "//fieldset[@class='fieldset']/input[@type='password'][@name='c_password']")

    SUBMIT_BUTTON = ("xpath", "//fieldset/input[@type='submit']")

    REQUIRED_FIELDS = ("xpath", "//fieldset[contains(@class, 'fieldset')]")
    REQUIRED_LABELS = ("xpath", "//fieldset[contains(@class, 'fieldset')]/label")

    TEXTS_REQUIRED_LABEL = []


    def enter_firstname(self, name):
        self.driver.find_element(*self.FIRSTNAME_INPUT).send_keys(name)

    def check_firstname(self):
        return self.driver.find_element(*self.FIRSTNAME_INPUT).get_attribute("value")

    def enter_lastname(self, name):
        self.driver.find_element(*self.LASTNAME_INPUT).send_keys(name)

    def check_lastname(self):
        return self.driver.find_element(*self.LASTNAME_INPUT).get_attribute("value")

    def set_marital_status(self, status):
        status_locators = {
            "Single": self.SINGLE_RADIO,
            "Married": self.MARRIED_RADIO,
            "Divorced": self.DIVORCED_RADIO
        }
        if status in status_locators:
            self.driver.find_element(*status_locators[status]).click()

    def check_married_status(self, status):
        status_locators = {
            "Single": self.SINGLE_RADIO,
            "Married": self.MARRIED_RADIO,
            "Divorced": self.DIVORCED_RADIO
        }
        if status in status_locators:
            checked = self.driver.find_element(*status_locators[status]).get_attribute("checked")
            return bool(checked)

    def set_hobby(self, hobby):
        hobby_locators = {
            "Dance": self.DANCE_CHECKBOX,
            "Reading": self.READING_CHECKBOX,
            "Cricket": self.CRICKET_CHECKBOX
        }
        if hobby in hobby_locators:
            self.driver.find_element(*hobby_locators[hobby]).click()

    def check_hobby(self, hobby):
        hobby_locators = {
            "Dance": self.DANCE_CHECKBOX,
            "Reading": self.READING_CHECKBOX,
            "Cricket": self.CRICKET_CHECKBOX
        }
        if hobby in hobby_locators:
            checked = self.driver.find_element(*hobby_locators[hobby]).get_attribute("checked")
            return bool(checked)

    def select_country(self, index):
        select_element = self.driver.find_element(*self.COUNTRY_SELECT)
        select = Select(select_element)
        select.select_by_index(index - 1)

    def check_country(self, index):
        india = self.driver.find_element(*self.COUNTRY_OPTION(index))
        return india.is_selected()

    def select_day_of_birth(self, day: str):
        select_element = self.driver.find_element(*self.DAY_SELECT)
        select = Select(select_element)
        select.select_by_visible_text(day)

    def check_day_of_birth(self, day: str):
        day = self.driver.find_element(*self.DAY_OPTION(day))
        return day.is_selected()

    def select_month_of_birth(self, month: str):
        select_element = self.driver.find_element(*self.MONTH_SELECT)
        select = Select(select_element)
        select.select_by_visible_text(month)

    def check_month_of_birth(self, month: str):
        month = self.driver.find_element(*self.MONTH_OPTION(month))
        return month.is_selected()

    def select_year_of_birth(self, year: str):
        select_element = self.driver.find_element(*self.YEAR_SELECT)
        select = Select(select_element)
        select.select_by_visible_text(year)

    def check_year_of_birth(self, year: str):
        year = self.driver.find_element(*self.YEAR_OPTION(year))
        return year.is_selected()

    def enter_phone(self, phone):
        self.driver.find_element(*self.PHONE_INPUT).send_keys(phone)

    def check_phone(self):
        return self.driver.find_element(*self.PHONE_INPUT).get_attribute("value")

    def enter_username(self, username):
        self.driver.find_element(*self.USERNAME_INPUT).send_keys(username)

    def check_username(self):
        return self.driver.find_element(*self.USERNAME_INPUT).get_attribute("value")

    def enter_email(self, email):
        self.driver.find_element(*self.EMAIL_INPUT).send_keys(email)

    def check_email(self):
        return self.driver.find_element(*self.EMAIL_INPUT).get_attribute("value")

    def upload_file(self, filepath):
        upload_file = os.path.abspath(filepath)
        self.driver.find_element(*self.FILE_INPUT).send_keys(upload_file)

    def enter_answers_to_about_yourself(self):
        self.driver.find_element(*self.ABOUT_YOURSELF).send_keys(str(task1.solve([2025, 3, 11]))
                                                                 + "," +
                                                                 str(task2.solve([1, 3, 6, 7, 9, 4, 10, 5, 6, 12, 2, 7, 11]))
                                                                 + "," +
                                                                 str(task3.solve("aabbdsaacc", "abadc")))

    def check_email(self):
        return self.driver.find_element(*self.EMAIL_INPUT).get_attribute("value")

    def enter_password(self, password):
        self.driver.find_element(*self.PASSWORD_INPUT).send_keys(password)

    def check_password(self):
        return self.driver.find_element(*self.PASSWORD_INPUT).get_attribute("value")

    def enter_confirm_password(self, password):
        self.driver.find_element(*self.CONFIRM_PASSWORD_INPUT).send_keys(password)

    def check_confirm_password(self):
        return self.driver.find_element(*self.CONFIRM_PASSWORD_INPUT).get_attribute("value")

    def click_submit(self):
        required_labels = [self.driver.find_element(*self.FIRSTNAME_LABEL),
                           self.driver.find_element(*self.LASTNAME_LABEL)]
        required_labels.extend(self.driver.find_elements(*self.REQUIRED_LABELS))
        self.texts = [f.text for f in required_labels]
        self.find_and_click(self.SUBMIT_BUTTON)

    def check_required_fields(self):
        # required_labels = []
        # required_labels.append(self.driver.find_element(*self.FIRSTNAME_LABEL))
        # required_labels.append(self.driver.find_element(*self.LASTNAME_LABEL))
        # required_labels.extend(self.driver.find_elements(*self.REQUIRED_LABELS))
        # incorrect_fields = []
        count = 0
        fields = self.driver.find_elements(*self.REQUIRED_FIELDS)
        for i in range(len(fields)):
            atr_class = fields[i].get_attribute("class")
            if "error_p" in atr_class:
                count += 1
        return count
